/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.I18n;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MandelbrotDisplay
extends JPanel {
    public static final int PALETTE_SPECTRUM = 0;
    public static final int PALETTE_PALE_SPECTRUM = 1;
    public static final int PALETTE_GRAYSCALE = 2;
    public static final int PALETTE_REVERSE_GRAYSCALE = 3;
    public static final int PALETTE_GRADIENT = 4;
    public static final String LIMITS_PROPERTY = "MandelbrotLimits";
    public static final String STATUS_PROPERTY = "MandelbrotStatus";
    public static final String STATUS_WORKING = "working";
    public static final String STATUS_READY = "ready";
    public static final String STATUS_OUT_OF_MEMORY = "out of memory";
    private String status = "ready";
    private BufferedImage OSC;
    private int[][] iterationCounts;
    private int imageWidth;
    private int maxIterations = 50;
    private int paletteType;
    private Color gradientPaletteColor1;
    private Color gradientPaletteColor2;
    private int paletteLength;
    private int[] palette;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double dx;
    private double dy;
    private double xmin_requested = -2.5;
    private double xmax_requested = 1.1;
    private double ymin_requested = -1.35;
    private double ymax_requested = 1.35;
    private Rectangle zoomBox;
    private Timer delayedResizeTimer;
    private volatile boolean computing;
    private ComputeThread[] workerThreads;
    private int jobs;
    private int jobsAssigned;
    private int jobsCompleted;
    private LinkedList<Job> finishedJobs;
    private int computationNumber;
    private boolean shutDown;
    private int[] rgb;
    private Timer applyJobsToImageTimer;

    public MandelbrotDisplay() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setBackground(Color.LIGHT_GRAY);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (MandelbrotDisplay.this.delayedResizeTimer != null) {
                    MandelbrotDisplay.this.delayedResizeTimer.stop();
                    MandelbrotDisplay.this.delayedResizeTimer = null;
                }
                if (MandelbrotDisplay.this.OSC != null) {
                    MandelbrotDisplay.this.delayedResizeTimer = new Timer(100, new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            MandelbrotDisplay.this.delayedResizeTimer = null;
                            MandelbrotDisplay.this.repaint();
                        }
                    });
                    MandelbrotDisplay.this.delayedResizeTimer.setInitialDelay(333);
                    MandelbrotDisplay.this.delayedResizeTimer.setRepeats(false);
                    MandelbrotDisplay.this.delayedResizeTimer.start();
                }
            }
        });
        this.applyJobsToImageTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MandelbrotDisplay.this.applyFinishedJobsToImage();
            }
        });
    }

    public BufferedImage getImage() {
        return this.OSC;
    }

    public String getStatus() {
        return this.status;
    }

    public void setLimits(double xmin, double xmax, double ymin, double ymax) {
        if (xmin == this.xmin && xmax == this.xmax && ymin == this.ymin && ymax == this.ymax) {
            return;
        }
        double[] oldLimits = new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
        this.stopComputing();
        this.xmin_requested = xmin;
        this.xmax_requested = xmax;
        this.ymin_requested = ymin;
        this.ymax_requested = ymax;
        this.startComputing();
        this.repaint();
        double[] newLimits = new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
        this.firePropertyChange(LIMITS_PROPERTY, oldLimits, newLimits);
    }

    public double[] getLimits() {
        return new double[]{this.xmin, this.xmax, this.ymin, this.ymax};
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public synchronized void setMaxIterations(int max) {
        if (max == this.maxIterations) {
            return;
        }
        this.stopComputing();
        this.maxIterations = max;
        if (this.paletteLength == 0) {
            this.palette = null;
        }
        this.startComputing();
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public synchronized void setPaletteType(int type) {
        if (type == this.paletteType) {
            return;
        }
        if (type != 0 && type != 1 && type != 2 && type != 3) {
            return;
        }
        this.gradientPaletteColor2 = null;
        this.gradientPaletteColor1 = null;
        this.paletteType = type;
        this.palette = null;
        this.recomputeColors();
    }

    public synchronized void setGradientPalette(Color color1, Color color2) {
        if (this.paletteType == 4 && this.gradientPaletteColor1.equals(color1) && this.gradientPaletteColor2.equals(color2)) {
            return;
        }
        if (color1 == null || color2 == null) {
            return;
        }
        this.paletteType = 4;
        this.gradientPaletteColor1 = color1;
        this.gradientPaletteColor2 = color2;
        this.palette = null;
        this.recomputeColors();
    }

    public int getPaletteType() {
        return this.paletteType;
    }

    public Color getGradientPaletteColor1() {
        return this.gradientPaletteColor1;
    }

    public Color getGradientPaletteColor2() {
        return this.gradientPaletteColor2;
    }

    synchronized void setPaletteLength(int length) {
        if (length <= 0) {
            length = 0;
        }
        if (length == this.paletteLength) {
            return;
        }
        this.paletteLength = length;
        this.palette = null;
        this.recomputeColors();
    }

    public int getPaletteLength() {
        return this.paletteLength;
    }

    public boolean drawZoomBox(Rectangle rect) {
        if (this.zoomBox != null) {
            this.repaint(this.zoomBox.x - 1, this.zoomBox.y - 1, this.zoomBox.width + 3, this.zoomBox.height + 3);
        }
        if (this.OSC == null) {
            this.zoomBox = null;
            return false;
        }
        this.zoomBox = rect;
        if (this.zoomBox != null) {
            this.repaint(this.zoomBox.x - 1, this.zoomBox.y - 1, this.zoomBox.width + 3, this.zoomBox.height + 3);
        }
        return true;
    }

    public void applyZoom(boolean zoomOut) {
        if (this.zoomBox == null) {
            return;
        }
        if (this.zoomBox.width == 0 || this.zoomBox.height == 0) {
            this.zoomBox = null;
            this.repaint();
            return;
        }
        double x1 = this.xmin + (double)this.zoomBox.x / (double)this.getWidth() * (this.xmax - this.xmin);
        double x2 = this.xmin + (double)(this.zoomBox.x + this.zoomBox.width) / (double)this.getWidth() * (this.xmax - this.xmin);
        double y1 = this.ymax - ((double)this.zoomBox.y + (double)this.zoomBox.height) / (double)this.getHeight() * (this.ymax - this.ymin);
        double y2 = this.ymax - (double)this.zoomBox.y / (double)this.getHeight() * (this.ymax - this.ymin);
        double cx = (x1 + x2) / 2.0;
        double cy = (y1 + y2) / 2.0;
        if (zoomOut) {
            double newXmin = this.xmin + (this.xmin - x1) / (x2 - x1) * (this.xmax - this.xmin);
            double newXmax = this.xmin + (this.xmax - x1) / (x2 - x1) * (this.xmax - this.xmin);
            double newYmin = this.ymin + (this.ymin - y1) / (y2 - y1) * (this.ymax - this.ymin);
            double newYmax = this.ymin + (this.ymax - y1) / (y2 - y1) * (this.ymax - this.ymin);
            this.setLimits(newXmin, newXmax, newYmin, newYmax);
        } else {
            double newWidth = x2 - x1;
            double newHeight = y2 - y1;
            this.setLimits(cx - newWidth / 2.0, cx + newWidth / 2.0, cy - newHeight / 2.0, cy + newHeight / 2.0);
        }
        this.zoomBox = null;
    }

    public synchronized void shutDownThreads() {
        this.shutDown = true;
        this.notifyAll();
    }

    public void paintComponent(Graphics g) {
        if (this.delayedResizeTimer != null) {
            super.paintComponent(g);
            if (this.OSC != null) {
                g.drawImage(this.OSC, 0, 0, null);
            }
            this.zoomBox = null;
        } else {
            this.checkOSC();
            if (this.OSC == null) {
                super.paintComponent(g);
                g.setColor(Color.RED);
                g.drawString(I18n.tr("error.memory", new Object[0]), 20, 50);
                this.zoomBox = null;
            } else {
                g.drawImage(this.OSC, 0, 0, null);
                if (this.zoomBox != null) {
                    g.setColor(Color.WHITE);
                    g.drawRect(this.zoomBox.x - 1, this.zoomBox.y - 1, this.zoomBox.width + 2, this.zoomBox.height + 2);
                    g.setColor(Color.BLACK);
                    g.drawRect(this.zoomBox.x, this.zoomBox.y, this.zoomBox.width, this.zoomBox.height);
                    g.setColor(Color.WHITE);
                    g.drawRect(this.zoomBox.x + 1, this.zoomBox.y + 1, this.zoomBox.width - 2, this.zoomBox.height - 2);
                }
            }
        }
    }

    private void setStatus(String status) {
        if (status == this.status) {
            return;
        }
        String oldStatus = this.status;
        this.status = status;
        this.firePropertyChange(STATUS_PROPERTY, oldStatus, status);
    }

    private synchronized void checkOSC() {
        if (this.OSC == null || this.OSC.getWidth() != this.getWidth() || this.OSC.getHeight() != this.getHeight()) {
            this.stopComputing();
            this.OSC = null;
            this.iterationCounts = null;
            try {
                int width = this.getWidth();
                int height = this.getHeight();
                this.OSC = new BufferedImage(width, height, 1);
                this.iterationCounts = new int[height][width];
                this.rgb = new int[width];
                this.imageWidth = width;
                this.startComputing();
            }
            catch (OutOfMemoryError e) {
                this.OSC = null;
                this.iterationCounts = null;
                this.setStatus(STATUS_OUT_OF_MEMORY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void applyFinishedJobsToImage() {
        ArrayList<Job> temp;
        MandelbrotDisplay mandelbrotDisplay = this;
        synchronized (mandelbrotDisplay) {
            if (this.finishedJobs == null) {
                return;
            }
            temp = new ArrayList<Job>();
            while (!this.finishedJobs.isEmpty()) {
                temp.add(this.finishedJobs.removeFirst());
            }
        }
        for (Job job : temp) {
            this.iterationCounts[job.rowNumber] = job.iterationCounts;
            if (this.palette == null) {
                this.createPalette();
            }
            int i = 0;
            while (i < this.imageWidth) {
                this.rgb[i] = this.getColorForIterationCount(job.iterationCounts[i]);
                ++i;
            }
            this.OSC.setRGB(0, job.rowNumber, this.imageWidth, 1, this.rgb, 0, this.imageWidth);
            this.repaint(0, job.rowNumber, this.imageWidth, 1);
        }
    }

    private int getColorForIterationCount(int ct) {
        if (ct < 0) {
            return 0;
        }
        if (this.paletteLength == 0) {
            return this.palette[ct];
        }
        return this.palette[ct %= this.paletteLength];
    }

    private synchronized void recomputeColors() {
        if (this.OSC == null) {
            return;
        }
        if (this.palette == null) {
            this.createPalette();
        }
        int i = 0;
        while (i < this.iterationCounts.length) {
            if (this.iterationCounts[i] != null) {
                int j = 0;
                while (j < this.imageWidth) {
                    this.rgb[j] = this.getColorForIterationCount(this.iterationCounts[i][j]);
                    ++j;
                }
                this.OSC.setRGB(0, i, this.imageWidth, 1, this.rgb, 0, this.imageWidth);
            }
            ++i;
        }
        this.repaint();
    }

    private synchronized void stopComputing() {
        if (!this.computing || this.OSC == null) {
            return;
        }
        this.applyJobsToImageTimer.stop();
        this.applyFinishedJobsToImage();
        this.finishedJobs = null;
        this.computing = false;
        this.setStatus(STATUS_READY);
    }

    private synchronized void startComputing() {
        if (this.OSC == null) {
            return;
        }
        this.stopComputing();
        Graphics g = this.OSC.getGraphics();
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.dispose();
        this.repaint();
        int processCount = Runtime.getRuntime().availableProcessors();
        if (this.workerThreads == null) {
            System.out.println("Creating " + processCount + " threads.");
            this.workerThreads = new ComputeThread[processCount];
            int priority = Thread.currentThread().getPriority() - 1;
            int i = 0;
            while (i < processCount) {
                this.workerThreads[i] = new ComputeThread();
                try {
                    this.workerThreads[i].setDaemon(true);
                }
                catch (Exception e) {
                    System.out.println("Can't set thread to daemaon.");
                }
                try {
                    this.workerThreads[i].setPriority(priority);
                }
                catch (Exception e) {
                    System.out.println("Can't reduce worker thread priority?");
                }
                this.workerThreads[i].start();
                ++i;
            }
        }
        this.checkAspect();
        ++this.computationNumber;
        this.jobs = this.iterationCounts.length;
        this.jobsAssigned = 0;
        this.jobsCompleted = 0;
        this.computing = true;
        this.finishedJobs = new LinkedList();
        int i = 0;
        while (i < this.iterationCounts.length) {
            this.iterationCounts[i] = null;
            ++i;
        }
        this.notifyAll();
        this.applyJobsToImageTimer.start();
        this.setStatus(STATUS_WORKING);
    }

    private void checkAspect() {
        double windowAspect;
        double height;
        double width;
        double aspect;
        double temp;
        this.xmin = this.xmin_requested;
        this.xmax = this.xmax_requested;
        if (this.xmax < this.xmin) {
            temp = this.xmin;
            this.xmin = this.xmax;
            this.xmax = temp;
        }
        this.ymin = this.ymin_requested;
        this.ymax = this.ymax_requested;
        if (this.ymax < this.ymin) {
            temp = this.ymax;
            this.ymax = this.ymin;
            this.ymin = temp;
        }
        if ((aspect = (width = this.xmax - this.xmin) / (height = this.ymax - this.ymin)) < (windowAspect = (double)this.getWidth() / (double)this.getHeight())) {
            double newWidth = width * windowAspect / aspect;
            double center = (this.xmax + this.xmin) / 2.0;
            this.xmax = center + newWidth / 2.0;
            this.xmin = center - newWidth / 2.0;
        } else if (aspect > windowAspect) {
            double newHeight = height * aspect / windowAspect;
            double center = (this.ymax + this.ymin) / 2.0;
            this.ymax = center + newHeight / 2.0;
            this.ymin = center - newHeight / 2.0;
        }
        this.dx = (this.xmax - this.xmin) / (double)(this.getWidth() - 1);
        this.dy = (this.ymax - this.ymin) / (double)(this.getHeight() - 1);
    }

    private void createPalette() {
        this.palette = this.paletteLength == 0 ? new int[this.maxIterations + 1] : new int[this.paletteLength];
        int i = 0;
        while (i < this.palette.length) {
            Color color;
            float fraction = (float)i / (float)(this.palette.length - 1);
            switch (this.paletteType) {
                case 4: {
                    float r1 = (float)this.gradientPaletteColor1.getRed() / 255.0f;
                    float r2 = (float)this.gradientPaletteColor2.getRed() / 255.0f;
                    float r = Math.max(0.0f, Math.min(1.0f, r2 * fraction + r1 * (1.0f - fraction)));
                    float g1 = (float)this.gradientPaletteColor1.getGreen() / 255.0f;
                    float g2 = (float)this.gradientPaletteColor2.getGreen() / 255.0f;
                    float g = Math.max(0.0f, Math.min(1.0f, g2 * fraction + g1 * (1.0f - fraction)));
                    float b1 = (float)this.gradientPaletteColor1.getBlue() / 255.0f;
                    float b2 = (float)this.gradientPaletteColor2.getBlue() / 255.0f;
                    float b = Math.max(0.0f, Math.min(1.0f, b2 * fraction + b1 * (1.0f - fraction)));
                    color = new Color(r, g, b);
                    break;
                }
                case 0: {
                    color = Color.getHSBColor(0.95f * fraction, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    color = Color.getHSBColor(0.95f * fraction, 0.6f, 1.0f);
                    break;
                }
                case 2: {
                    color = new Color(0.9f * fraction, 0.9f * fraction, 0.9f * fraction);
                    break;
                }
                default: {
                    color = new Color(1.0f - 0.9f * fraction, 1.0f - 0.9f * fraction, 1.0f - 0.9f * fraction);
                }
            }
            this.palette[i] = color.getRGB();
            ++i;
        }
    }

    private synchronized Job getNextJob() {
        while (!this.computing && !this.shutDown) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.shutDown) {
            return null;
        }
        if (this.jobsAssigned >= this.jobs) {
            return null;
        }
        Job job = new Job();
        job.rowNumber = this.jobsAssigned;
        job.xmin = this.xmin;
        job.dx = this.dx;
        job.y = this.ymax - (double)this.jobsAssigned * this.dy;
        job.maxIterations = this.maxIterations;
        job.count = this.imageWidth;
        job.computationNumber = this.computationNumber;
        ++this.jobsAssigned;
        return job;
    }

    private synchronized void finish(Job job) {
        if (job.computationNumber != this.computationNumber) {
            return;
        }
        this.finishedJobs.addLast(job);
        ++this.jobsCompleted;
        if (this.jobsCompleted == this.jobs) {
            this.stopComputing();
        }
    }

    private class Job {
        double xmin;
        double dx;
        double y;
        int count;
        int maxIterations;
        int rowNumber;
        int computationNumber;
        int[] iterationCounts;

        private Job() {
        }

        void compute() {
            this.iterationCounts = new int[this.count];
            int i = 0;
            while (i < this.count) {
                double x0 = this.xmin + (double)i * this.dx;
                double y0 = this.y;
                double a = x0;
                double b = y0;
                int ct = 0;
                while (a * a + b * b < 4.1) {
                    if (++ct > this.maxIterations) {
                        ct = -1;
                        break;
                    }
                    double newa = a * a - b * b + x0;
                    b = 2.0 * a * b + y0;
                    a = newa;
                }
                this.iterationCounts[i] = ct;
                ++i;
            }
        }
    }

    private class ComputeThread
    extends Thread {
        private ComputeThread() {
        }

        public void run() {
            while (true) {
                Job job = MandelbrotDisplay.this.getNextJob();
                if (MandelbrotDisplay.this.shutDown) break;
                if (job == null) continue;
                job.compute();
                MandelbrotDisplay.this.finish(job);
            }
        }
    }
}

