/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.I18n;
import edu.hws.eck.mdb.MandelbrotFrame;
import edu.hws.eck.mdb.MandelbrotPanel;
import edu.hws.eck.mdb.SetImageSizeDialog;
import edu.hws.eck.mdb.SetLimitsDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Menus
extends JMenuBar {
    private MandelbrotPanel owner;
    private MandelbrotFrame frame;
    private PaletteManager paletteManager;
    private PaletteLengthManager paletteLengthManager;
    private MaxIterationsManager maxIterationsManager;
    private JFileChooser fileDialog;
    private double[] previousLimits;
    private String commandKey;
    private Action saveParams = new AbstractAction(I18n.tr("command.save", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            PrintWriter out;
            int response;
            if (Menus.this.fileDialog == null) {
                Menus.this.fileDialog = new JFileChooser();
            }
            File selectedFile = new File(I18n.tr("files.saveparams.defaultFileName", new Object[0]));
            Menus.this.fileDialog.setSelectedFile(selectedFile);
            Menus.this.fileDialog.setDialogTitle(I18n.tr("files.saveparams.title", new Object[0]));
            int option = Menus.this.fileDialog.showSaveDialog(Menus.this.owner);
            if (option != 0) {
                return;
            }
            selectedFile = Menus.this.fileDialog.getSelectedFile();
            if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(Menus.this.owner, I18n.tr("files.fileexists", selectedFile.getName()), I18n.tr("files.confirmsave.title", new Object[0]), 0, 2)) == 1) {
                return;
            }
            try {
                FileOutputStream stream = new FileOutputStream(selectedFile);
                out = new PrintWriter(stream);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("files.saveparams.error.cannotOpen", selectedFile.getName(), e.toString()));
                return;
            }
            try {
                out.print(Menus.this.currentSettingsAsXML());
                out.close();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("files.saveparams.error.cannotWrite", selectedFile.getName(), e.toString()));
            }
        }
    };
    private Action openParams = new AbstractAction(I18n.tr("command.open", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            Document xmldoc;
            if (Menus.this.fileDialog == null) {
                Menus.this.fileDialog = new JFileChooser();
            }
            Menus.this.fileDialog.setDialogTitle(I18n.tr("files.openparams.title", new Object[0]));
            Menus.this.fileDialog.setSelectedFile(null);
            int option = Menus.this.fileDialog.showOpenDialog(Menus.this.owner);
            if (option != 0) {
                return;
            }
            File selectedFile = Menus.this.fileDialog.getSelectedFile();
            try {
                DocumentBuilder docReader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                xmldoc = docReader.parse(selectedFile);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("files.openparams.error.notXML", selectedFile.getName(), e.toString()));
                return;
            }
            try {
                Menus.this.retrieveSettingsFromXML(xmldoc);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("files.openparams.error.notParamsFile", selectedFile.getName(), e.getMessage()));
            }
        }
    };
    private Action saveImage = new AbstractAction(I18n.tr("command.saveImage", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            int response;
            BufferedImage image;
            if (Menus.this.fileDialog == null) {
                Menus.this.fileDialog = new JFileChooser();
            }
            if ((image = Menus.this.owner.getDisplay().getImage()) == null) {
                JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("files.saveimage.noImage", new Object[0]));
                return;
            }
            Menus.this.fileDialog.setSelectedFile(new File(I18n.tr("files.saveimage.defaultFileName", new Object[0])));
            Menus.this.fileDialog.setDialogTitle(I18n.tr("files.saveimage.title", new Object[0]));
            int option = Menus.this.fileDialog.showSaveDialog(Menus.this.owner);
            if (option != 0) {
                return;
            }
            File selectedFile = Menus.this.fileDialog.getSelectedFile();
            if (selectedFile.exists() && (response = JOptionPane.showConfirmDialog(Menus.this.owner, I18n.tr("files.fileexists", selectedFile.getName()), I18n.tr("files.confirmsave.title", new Object[0]), 0, 2)) == 1) {
                return;
            }
            try {
                boolean hasPNG = ImageIO.write((RenderedImage)image, "PNG", selectedFile);
                if (!hasPNG) {
                    throw new Exception(I18n.tr("files.saveimage.noPNG", new Object[0]));
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("files.saveimage.cantwrite", selectedFile.getName(), e.toString()));
            }
        }
    };
    private Action close = new AbstractAction(I18n.tr("command.close", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            Menus.this.frame.dispose();
        }
    };
    private Action defaultLimits = new AbstractAction(I18n.tr("command.defaultLimits", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            Menus.this.owner.getDisplay().setLimits(-2.5, 1.1, -1.35, 1.35);
        }
    };
    private Action allDefaults = new AbstractAction(I18n.tr("command.restoreAllDefaults", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            Menus.this.owner.getDisplay().setLimits(-2.5, 1.1, -1.35, 1.35);
            Menus.this.paletteManager.setDefault();
            Menus.this.paletteLengthManager.setDefault();
            Menus.this.maxIterationsManager.setDefault();
        }
    };
    private Action undoChangeOfLimits = new AbstractAction(I18n.tr("command.undoChangeOfLimits", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            if (Menus.this.previousLimits != null) {
                Menus.this.owner.getDisplay().setLimits(Menus.this.previousLimits[0], Menus.this.previousLimits[1], Menus.this.previousLimits[2], Menus.this.previousLimits[3]);
            }
        }
    };
    private Action showLimits = new AbstractAction(I18n.tr("command.showLimits", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            String[] limits = Menus.this.makeScaledLimitStrings();
            JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("dialog.showLimits", limits[0], limits[1], limits[2], limits[3]));
        }
    };
    private Action setImageSize = new AbstractAction(I18n.tr("command.enterImageSize", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            Dimension oldSize = Menus.this.owner.getDisplay().getSize();
            Dimension newSize = SetImageSizeDialog.showDialog(Menus.this.frame, oldSize);
            if (newSize == null) {
                return;
            }
            Menus.this.owner.getDisplay().setPreferredSize(newSize);
            Menus.this.frame.pack();
            Menus.this.frame.adjustToScreenIfNecessary();
        }
    };
    private Action setLimits = new AbstractAction(I18n.tr("command.enterLimits", new Object[0])){

        public void actionPerformed(ActionEvent evt) {
            String[] limits = Menus.this.makeScaledLimitStrings();
            double[] newLimits = SetLimitsDialog.showDialog(Menus.this.frame, limits);
            if (newLimits != null) {
                Menus.this.owner.getDisplay().setLimits(newLimits[0], newLimits[1], newLimits[2], newLimits[3]);
            }
        }
    };

    public Menus(MandelbrotPanel owner, MandelbrotFrame frame, boolean runningAsApplet) {
        JRadioButtonMenuItem item;
        this.owner = owner;
        this.frame = frame;
        this.paletteManager = new PaletteManager();
        this.paletteLengthManager = new PaletteLengthManager();
        this.maxIterationsManager = new MaxIterationsManager();
        if (frame != null) {
            this.saveParams.putValue("AcceleratorKey", this.makeAccelerator("S"));
            this.saveImage.putValue("AcceleratorKey", this.makeAccelerator("shift S"));
            this.openParams.putValue("AcceleratorKey", this.makeAccelerator("O"));
            if (runningAsApplet) {
                this.close.putValue("AcceleratorKey", this.makeAccelerator("W"));
            } else {
                this.close.putValue("Name", "Quit");
                this.close.putValue("AcceleratorKey", this.makeAccelerator("Q"));
            }
            this.defaultLimits.putValue("AcceleratorKey", this.makeAccelerator("R"));
            this.allDefaults.putValue("AcceleratorKey", this.makeAccelerator("shift R"));
            this.undoChangeOfLimits.putValue("AcceleratorKey", this.makeAccelerator("U"));
            this.showLimits.putValue("AcceleratorKey", this.makeAccelerator("L"));
            this.setLimits.putValue("AcceleratorKey", this.makeAccelerator("shift L"));
            this.setImageSize.putValue("AcceleratorKey", this.makeAccelerator("shift I"));
            this.paletteManager.items[0].setAccelerator(this.makeAccelerator("T"));
            this.paletteLengthManager.items[0].setAccelerator(this.makeAccelerator("M"));
        }
        if (!runningAsApplet) {
            JMenu fileMenu = new JMenu(I18n.tr("menu.file", new Object[0]));
            this.add(fileMenu);
            fileMenu.add(this.saveParams);
            fileMenu.add(this.openParams);
            fileMenu.addSeparator();
            fileMenu.add(this.saveImage);
            fileMenu.addSeparator();
            fileMenu.add(this.close);
        }
        JMenu controlMenu = new JMenu(I18n.tr("menu.control", new Object[0]));
        this.add(controlMenu);
        JMenu maxIterationsMenu = new JMenu(I18n.tr("menu.maxIterations", new Object[0]));
        this.add(maxIterationsMenu);
        JMenu paletteMenu = new JMenu(I18n.tr("menu.palette", new Object[0]));
        this.add(paletteMenu);
        JMenu paletteLengthMenu = new JMenu(I18n.tr("menu.paletteLength", new Object[0]));
        this.add(paletteLengthMenu);
        controlMenu.add(this.allDefaults);
        controlMenu.addSeparator();
        controlMenu.add(this.defaultLimits);
        controlMenu.add(this.undoChangeOfLimits);
        this.undoChangeOfLimits.setEnabled(false);
        controlMenu.add(this.showLimits);
        controlMenu.add(this.setLimits);
        if (frame != null) {
            controlMenu.addSeparator();
            controlMenu.add(this.setImageSize);
        }
        if (frame != null && runningAsApplet) {
            controlMenu.addSeparator();
            controlMenu.add(this.close);
        }
        JRadioButtonMenuItem[] jRadioButtonMenuItemArray = this.paletteManager.items;
        int n = 0;
        int n2 = jRadioButtonMenuItemArray.length;
        while (n < n2) {
            item = jRadioButtonMenuItemArray[n];
            paletteMenu.add(item);
            ++n;
        }
        jRadioButtonMenuItemArray = this.paletteLengthManager.items;
        n = 0;
        n2 = jRadioButtonMenuItemArray.length;
        while (n < n2) {
            item = jRadioButtonMenuItemArray[n];
            paletteLengthMenu.add(item);
            ++n;
        }
        jRadioButtonMenuItemArray = this.maxIterationsManager.items;
        n = 0;
        n2 = jRadioButtonMenuItemArray.length;
        while (n < n2) {
            item = jRadioButtonMenuItemArray[n];
            maxIterationsMenu.add(item);
            ++n;
        }
        owner.getDisplay().addPropertyChangeListener("MandelbrotLimits", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName() == "MandelbrotLimits") {
                    Menus.this.previousLimits = (double[])e.getOldValue();
                    Menus.this.undoChangeOfLimits.setEnabled(true);
                }
            }
        });
        owner.getDisplay().addPropertyChangeListener("MandelbrotStatus", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName() == "MandelbrotStatus") {
                    Menus.this.newDisplayStatus(e.getNewValue());
                }
            }
        });
        this.newDisplayStatus(owner.getDisplay().getStatus());
    }

    public String getSelectedDirectoryInFileChooser() {
        if (this.fileDialog == null) {
            return null;
        }
        File dir = this.fileDialog.getCurrentDirectory();
        if (dir == null) {
            return null;
        }
        return dir.getAbsolutePath();
    }

    public void setSelectedDirectoryInFileChooser(String path) {
        File dir = new File(path);
        if (dir.isDirectory()) {
            if (this.fileDialog == null) {
                this.fileDialog = new JFileChooser();
            }
            this.fileDialog.setCurrentDirectory(dir);
        }
    }

    public void retrieveSettingsFromXML(Document xmlDoc) {
        Element docElement = xmlDoc.getDocumentElement();
        String docName = docElement.getTagName();
        if (!docName.equalsIgnoreCase("mandelbrot_settings")) {
            throw new IllegalArgumentException(I18n.tr("xml.error.wrongType", docName));
        }
        String version = docElement.getAttribute("version");
        if (!version.equalsIgnoreCase("edu.hws.eck.mdb/1.0")) {
            throw new IllegalArgumentException(I18n.tr("xml.error.wrongSettingsVersion", new Object[0]));
        }
        NodeList nodes = docElement.getChildNodes();
        int ct = nodes.getLength();
        int i = 0;
        while (i < ct) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                String name = ((Element)node).getTagName();
                String value = ((Element)node).getAttribute("value");
                try {
                    if (name.equalsIgnoreCase("palettetype")) {
                        this.paletteManager.setValueFromString(value);
                    } else if (name.equalsIgnoreCase("palettelength")) {
                        this.paletteLengthManager.setValueFromString(value);
                    } else if (name.equalsIgnoreCase("maxiterations")) {
                        this.maxIterationsManager.setValueFromString(value);
                    } else if (name.equalsIgnoreCase("limits")) {
                        String[] limitStrings = this.explode(value, ",");
                        double xmin = Double.parseDouble(limitStrings[0]);
                        double xmax = Double.parseDouble(limitStrings[1]);
                        double ymin = Double.parseDouble(limitStrings[2]);
                        double ymax = Double.parseDouble(limitStrings[3]);
                        this.owner.getDisplay().setLimits(xmin, xmax, ymin, ymax);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(I18n.tr("xml.error.illegalSettingsValue", name, value));
                }
            }
            ++i;
        }
    }

    public String currentSettingsAsXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>\n");
        buffer.append("<mandelbrot_settings version='edu.hws.eck.mdb/1.0'>\n");
        double[] limits = this.owner.getDisplay().getLimits();
        String limitString = String.valueOf(limits[0]) + "," + limits[1] + "," + limits[2] + "," + limits[3];
        buffer.append("<limits value='" + limitString + "'/>\n");
        String sizeString = String.valueOf(this.owner.getDisplay().getWidth()) + "," + this.owner.getDisplay().getHeight();
        buffer.append("<imagesize value='" + sizeString + "'/>\n");
        buffer.append("<maxiterations value='" + this.maxIterationsManager.valueAsString() + "'/>\n");
        buffer.append("<palettetype value='" + this.paletteManager.valueAsString() + "'/>\n");
        buffer.append("<palettelength value='" + this.paletteLengthManager.valueAsString() + "'/>\n");
        buffer.append("</mandelbrot_settings>\n");
        return buffer.toString();
    }

    private KeyStroke makeAccelerator(String description) {
        if (this.commandKey == null) {
            this.commandKey = "cntr ";
            if (System.getProperty("mrj.version") != null) {
                this.commandKey = "meta ";
            }
        }
        return KeyStroke.getKeyStroke(String.valueOf(this.commandKey) + description);
    }

    private String[] explode(String str, String separators) {
        StringTokenizer tokenizer = new StringTokenizer(str, separators);
        int ct = tokenizer.countTokens();
        String[] tokens = new String[ct];
        int i = 0;
        while (i < ct) {
            tokens[i] = tokenizer.nextToken();
            ++i;
        }
        return tokens;
    }

    private void newDisplayStatus(Object status) {
        boolean ready = status.equals("ready");
        boolean outofmem = status.equals("out of memory");
        this.saveImage.setEnabled(ready);
        this.saveParams.setEnabled(ready);
        this.openParams.setEnabled(ready);
        this.setLimits.setEnabled(ready);
        this.setImageSize.setEnabled(ready || outofmem);
        this.maxIterationsManager.setEnabled(ready || outofmem);
    }

    private String[] makeScaledLimitStrings() {
        double xmin = this.owner.getDisplay().getXmin();
        double xmax = this.owner.getDisplay().getXmax();
        double ymin = this.owner.getDisplay().getYmin();
        double ymax = this.owner.getDisplay().getYmax();
        double diff = xmax - xmin;
        if (diff == 0.0) {
            return new String[]{"" + xmin, "" + xmax, "" + ymin, "" + ymax};
        }
        int scale = 4;
        if (diff > 0.0) {
            while (diff < 1.0) {
                ++scale;
                diff *= 10.0;
            }
        }
        String fmt = "%1." + scale + "f";
        String[] str = new String[]{String.format(fmt, xmin), String.format(fmt, xmax), String.format(fmt, ymin), String.format(fmt, ymax)};
        return str;
    }

    private class PaletteManager
    implements ActionListener {
        JRadioButtonMenuItem[] items;
        int selectedItem = 0;
        private String[] valueStrings = new String[]{"Spectrum", "PaleSpectrum", "Grayscale", "ReverseGrayscale", "BlackToRed", "RedToCyan", "OrangeToBlue"};

        PaletteManager() {
            this.items = new JRadioButtonMenuItem[8];
            this.items[0] = new JRadioButtonMenuItem(I18n.tr("command.palette.spectrum", new Object[0]));
            this.items[1] = new JRadioButtonMenuItem(I18n.tr("command.palette.paleSpectrum", new Object[0]));
            this.items[2] = new JRadioButtonMenuItem(I18n.tr("command.palette.grayscale", new Object[0]));
            this.items[3] = new JRadioButtonMenuItem(I18n.tr("command.palette.reverseGrayscale", new Object[0]));
            this.items[4] = new JRadioButtonMenuItem(I18n.tr("command.palette.gradientBlackToRed", new Object[0]));
            this.items[5] = new JRadioButtonMenuItem(I18n.tr("command.palette.gradientRedToCyan", new Object[0]));
            this.items[6] = new JRadioButtonMenuItem(I18n.tr("command.palette.gradientOrangeToBlue", new Object[0]));
            this.items[7] = new JRadioButtonMenuItem(I18n.tr("command.palette.customGradient", new Object[0]));
            this.items[this.selectedItem].setSelected(true);
            ButtonGroup grp = new ButtonGroup();
            int i = 0;
            while (i < this.items.length) {
                grp.add(this.items[i]);
                this.items[i].addActionListener(this);
                ++i;
            }
        }

        void setDefault() {
            this.items[0].setSelected(true);
            this.selectedItem = 0;
            Menus.this.owner.getDisplay().setPaletteType(0);
        }

        String valueAsString() {
            if (this.selectedItem < this.valueStrings.length) {
                return this.valueStrings[this.selectedItem];
            }
            Color c1 = Menus.this.owner.getDisplay().getGradientPaletteColor1();
            Color c2 = Menus.this.owner.getDisplay().getGradientPaletteColor2();
            if (c1 == null || c2 == null) {
                return this.valueStrings[0];
            }
            return "Custom/" + c1.getRed() + "," + c1.getGreen() + "," + c1.getBlue() + "/" + c2.getRed() + "," + c2.getGreen() + "," + c2.getBlue();
        }

        void setValueFromString(String str) {
            int i = 0;
            while (i < this.valueStrings.length) {
                if (this.valueStrings[i].equalsIgnoreCase(str)) {
                    this.items[i].setSelected(true);
                    this.applySelection();
                    return;
                }
                ++i;
            }
            String[] tokens = Menus.this.explode(str, "/,");
            if (!tokens[0].equalsIgnoreCase("custom")) {
                throw new IllegalArgumentException();
            }
            Color c1 = new Color(Integer.parseInt(tokens[1]), Integer.parseInt(tokens[2]), Integer.parseInt(tokens[3]));
            Color c2 = new Color(Integer.parseInt(tokens[4]), Integer.parseInt(tokens[5]), Integer.parseInt(tokens[6]));
            Menus.this.owner.getDisplay().setGradientPalette(c1, c2);
            this.items[7].setSelected(true);
            this.selectedItem = 7;
        }

        public void actionPerformed(ActionEvent evt) {
            this.applySelection();
        }

        private void applySelection() {
            if (this.items[0].isSelected()) {
                Menus.this.owner.getDisplay().setPaletteType(0);
                this.selectedItem = 0;
            } else if (this.items[1].isSelected()) {
                Menus.this.owner.getDisplay().setPaletteType(1);
                this.selectedItem = 1;
            } else if (this.items[2].isSelected()) {
                Menus.this.owner.getDisplay().setPaletteType(2);
                this.selectedItem = 2;
            } else if (this.items[3].isSelected()) {
                Menus.this.owner.getDisplay().setPaletteType(3);
                this.selectedItem = 3;
            } else if (this.items[4].isSelected()) {
                Menus.this.owner.getDisplay().setGradientPalette(Color.BLACK, Color.RED);
                this.selectedItem = 4;
            } else if (this.items[5].isSelected()) {
                Menus.this.owner.getDisplay().setGradientPalette(Color.RED, Color.CYAN);
                this.selectedItem = 5;
            } else if (this.items[6].isSelected()) {
                Menus.this.owner.getDisplay().setGradientPalette(new Color(255, 130, 20), new Color(0, 0, 255));
                this.selectedItem = 6;
            } else {
                Color c1 = Color.BLACK;
                Color c2 = Color.WHITE;
                if (Menus.this.owner.getDisplay().getPaletteType() == 4) {
                    c1 = Menus.this.owner.getDisplay().getGradientPaletteColor1();
                    c2 = Menus.this.owner.getDisplay().getGradientPaletteColor2();
                }
                if ((c1 = JColorChooser.showDialog(Menus.this.owner, "Select Gradient Start Color", c1)) == null) {
                    this.items[this.selectedItem].setSelected(true);
                    return;
                }
                c2 = JColorChooser.showDialog(Menus.this.owner, "Select Gradient End Color", c2);
                if (c2 == null) {
                    this.items[this.selectedItem].setSelected(true);
                    return;
                }
                Menus.this.owner.getDisplay().setGradientPalette(c1, c2);
                this.selectedItem = 7;
            }
        }
    }

    private class PaletteLengthManager
    implements ActionListener {
        int[] standardLengths = new int[]{25, 50, 100, 250, 500, 1000, 2000, 5000, 10000};
        int selectedItem = 0;
        JRadioButtonMenuItem[] items = new JRadioButtonMenuItem[2 + this.standardLengths.length];

        PaletteLengthManager() {
            this.items[0] = new JRadioButtonMenuItem(I18n.tr("command.pallete.lengthTracksMaxIterations", new Object[0]));
            int i = 0;
            while (i < this.standardLengths.length) {
                this.items[i + 1] = new JRadioButtonMenuItem(I18n.tr("command.palette.length", "" + this.standardLengths[i]));
                ++i;
            }
            this.items[this.items.length - 1] = new JRadioButtonMenuItem(I18n.tr("command.palette.customLength", new Object[0]));
            this.items[this.selectedItem].setSelected(true);
            ButtonGroup grp = new ButtonGroup();
            int i2 = 0;
            while (i2 < this.items.length) {
                grp.add(this.items[i2]);
                this.items[i2].addActionListener(this);
                ++i2;
            }
        }

        void setDefault() {
            this.selectedItem = 0;
            Menus.this.owner.getDisplay().setPaletteLength(0);
            this.items[0].setSelected(true);
        }

        String valueAsString() {
            return "" + Menus.this.owner.getDisplay().getPaletteLength();
        }

        void setValueFromString(String str) {
            int length = Integer.parseInt(str);
            if (length < 0 || length > 500000) {
                throw new IllegalArgumentException();
            }
            if (length == 0) {
                this.selectedItem = 0;
                Menus.this.owner.getDisplay().setPaletteLength(0);
                this.items[0].setSelected(true);
                return;
            }
            int i = 0;
            while (i < this.standardLengths.length) {
                if (length == this.standardLengths[i]) {
                    this.selectedItem = i + 1;
                    Menus.this.owner.getDisplay().setPaletteLength(this.standardLengths[i]);
                    this.items[i + 1].setSelected(true);
                    return;
                }
                ++i;
            }
            this.items[this.items.length - 1].setSelected(true);
            Menus.this.owner.getDisplay().setPaletteLength(length);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.items[0].isSelected()) {
                Menus.this.owner.getDisplay().setPaletteLength(0);
                this.selectedItem = 0;
            } else if (this.items[this.items.length - 1].isSelected()) {
                String lengthStr = JOptionPane.showInputDialog(I18n.tr("command.palette.customLengthQuestion", new Object[0]), (Object)Menus.this.owner.getDisplay().getPaletteLength());
                if (lengthStr == null || lengthStr.trim().length() == 0) {
                    this.items[this.selectedItem].setSelected(true);
                    return;
                }
                try {
                    int length = Integer.parseInt(lengthStr);
                    if (length < 0) {
                        throw new NumberFormatException();
                    }
                    if (length > 500000) {
                        throw new NumberFormatException();
                    }
                    Menus.this.owner.getDisplay().setPaletteLength(length);
                    this.selectedItem = this.items.length - 1;
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("command.palette.customLengthError", lengthStr));
                    this.items[this.selectedItem].setSelected(true);
                    return;
                }
            } else {
                int i = 0;
                while (i < this.standardLengths.length) {
                    if (this.items[i + 1].isSelected()) {
                        Menus.this.owner.getDisplay().setPaletteLength(this.standardLengths[i]);
                        this.selectedItem = i + 1;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private class MaxIterationsManager
    implements ActionListener {
        int[] standardValues = new int[]{50, 100, 250, 500, 1000, 2000, 5000, 20000, 50000, 100000};
        int selectedItem = 0;
        JRadioButtonMenuItem[] items = new JRadioButtonMenuItem[1 + this.standardValues.length];

        MaxIterationsManager() {
            int i = 0;
            while (i < this.standardValues.length) {
                this.items[i] = new JRadioButtonMenuItem(I18n.tr("command.maxiterations", "" + this.standardValues[i]));
                ++i;
            }
            this.items[this.items.length - 1] = new JRadioButtonMenuItem(I18n.tr("command.maxiterations.custom", new Object[0]));
            this.items[this.selectedItem].setSelected(true);
            ButtonGroup grp = new ButtonGroup();
            int i2 = 0;
            while (i2 < this.items.length) {
                grp.add(this.items[i2]);
                this.items[i2].addActionListener(this);
                ++i2;
            }
        }

        void setEnabled(boolean enable) {
            JRadioButtonMenuItem[] jRadioButtonMenuItemArray = this.items;
            int n = 0;
            int n2 = jRadioButtonMenuItemArray.length;
            while (n < n2) {
                JRadioButtonMenuItem item = jRadioButtonMenuItemArray[n];
                item.setEnabled(enable);
                ++n;
            }
        }

        void setDefault() {
            this.selectedItem = 0;
            Menus.this.owner.getDisplay().setMaxIterations(this.standardValues[0]);
            this.items[0].setSelected(true);
        }

        String valueAsString() {
            return "" + Menus.this.owner.getDisplay().getMaxIterations();
        }

        void setValueFromString(String str) {
            int length = Integer.parseInt(str);
            if (length < 0 || length > 500000) {
                throw new IllegalArgumentException();
            }
            int i = 0;
            while (i < this.standardValues.length) {
                if (length == this.standardValues[i]) {
                    this.selectedItem = i;
                    Menus.this.owner.getDisplay().setMaxIterations(this.standardValues[i]);
                    this.items[i].setSelected(true);
                    return;
                }
                ++i;
            }
            this.items[this.items.length - 1].setSelected(true);
            Menus.this.owner.getDisplay().setMaxIterations(length);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.items[this.items.length - 1].isSelected()) {
                String valueStr = JOptionPane.showInputDialog(I18n.tr("command.maxiterations.customQuestion", new Object[0]), (Object)Menus.this.owner.getDisplay().getMaxIterations());
                if (valueStr == null || valueStr.trim().length() == 0) {
                    this.items[this.selectedItem].setSelected(true);
                    return;
                }
                try {
                    int value = Integer.parseInt(valueStr);
                    if (value < 0) {
                        throw new NumberFormatException();
                    }
                    if (value > 500000) {
                        throw new NumberFormatException();
                    }
                    Menus.this.owner.getDisplay().setMaxIterations(value);
                    this.selectedItem = this.items.length - 1;
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(Menus.this.owner, I18n.tr("command.maxiterations.customError", valueStr));
                    this.items[this.selectedItem].setSelected(true);
                    return;
                }
            } else {
                int i = 0;
                while (i < this.standardValues.length) {
                    if (this.items[i].isSelected()) {
                        Menus.this.owner.getDisplay().setMaxIterations(this.standardValues[i]);
                        this.selectedItem = i;
                        break;
                    }
                    ++i;
                }
            }
        }
    }
}

