/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetImageSizeDialog
extends JDialog {
    private Dimension inputSize;
    private JButton cancelButton;
    private JButton okButton;
    private JTextField widthInput;
    private JTextField heightInput;

    static Dimension showDialog(JFrame frame, Dimension oldSize) {
        SetImageSizeDialog dialog = new SetImageSizeDialog(frame, oldSize);
        dialog.setVisible(true);
        Dimension newSize = dialog.getInputSize();
        if (newSize == null || newSize.equals(oldSize)) {
            return null;
        }
        return newSize;
    }

    public SetImageSizeDialog(JFrame frame, Dimension oldSize) {
        super(frame, I18n.tr("imagesizedialog.title", new Object[0]), true);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(10, 10));
        this.setContentPane(content);
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (oldSize == null) {
            oldSize = new Dimension(800, 600);
        }
        this.widthInput = new JTextField("" + oldSize.width, 4);
        this.heightInput = new JTextField("" + oldSize.height, 4);
        JPanel input = new JPanel();
        input.add(Box.createHorizontalStrut(10));
        input.add(new JLabel(I18n.tr("imagesizedialog.widthequals", new Object[0])));
        input.add(this.widthInput);
        input.add(Box.createHorizontalStrut(10));
        input.add(new JLabel(I18n.tr("imagesizedialog.widthequals", new Object[0])));
        input.add(this.heightInput);
        this.cancelButton = new JButton(I18n.tr("button.cancel", new Object[0]));
        this.okButton = new JButton(I18n.tr("button.ok", new Object[0]));
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel buttons = new JPanel();
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        content.add((Component)new JLabel(I18n.tr("imagesizedialog.question", new Object[0])), "North");
        content.add((Component)input, "Center");
        content.add((Component)buttons, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocation(frame.getX() + 50, frame.getY() + 75);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = this.getX();
        int y = this.getY();
        if (x + this.getWidth() > screensize.width) {
            x = screensize.width - this.getWidth() - 30;
        }
        if (y + this.getHeight() > screensize.height) {
            y = screensize.height - this.getHeight() - 30;
        }
        this.setLocation(x, y);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SetImageSizeDialog.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SetImageSizeDialog.this.checkInput()) {
                    SetImageSizeDialog.this.dispose();
                }
            }
        });
    }

    public Dimension getInputSize() {
        return this.inputSize;
    }

    private boolean checkInput() {
        int height;
        int width;
        this.inputSize = null;
        try {
            width = Integer.parseInt(this.widthInput.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, I18n.tr("imagesizedialog.error.widthnotanumber", this.widthInput.getText()));
            this.widthInput.selectAll();
            this.widthInput.requestFocus();
            return false;
        }
        try {
            height = Integer.parseInt(this.heightInput.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, I18n.tr("imagesizedialog.error.heightnotanumber", this.heightInput.getText()));
            this.heightInput.selectAll();
            this.heightInput.requestFocus();
            return false;
        }
        if (width < 10 || width > 5000) {
            JOptionPane.showMessageDialog(this, I18n.tr("imagesizedialog.error.badwidth", "" + width));
            this.widthInput.selectAll();
            this.widthInput.requestFocus();
            return false;
        }
        if (height < 10 || height > 5000) {
            JOptionPane.showMessageDialog(this, I18n.tr("imagesizedialog.error.badheight", "" + width));
            this.heightInput.selectAll();
            this.heightInput.requestFocus();
            return false;
        }
        this.inputSize = new Dimension(width, height);
        return true;
    }
}

