/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.eck.mdb;

import edu.hws.eck.mdb.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SetLimitsDialog
extends JDialog {
    private double[] inputValues;
    boolean changed;
    private JButton cancelButton;
    private JButton okButton;
    private JTextField[] inputBoxes;
    private String[] oldLimitStrings;
    private static final String[] names = new String[]{"limitsdialog.xmin", "limitsdialog.xmax", "limitsdialog.ymin", "limitsdialog.ymax"};

    static double[] showDialog(JFrame frame, String[] oldLimitStrings) {
        SetLimitsDialog dialog = new SetLimitsDialog(frame, oldLimitStrings);
        dialog.setVisible(true);
        return dialog.getInputsIfChanged();
    }

    public SetLimitsDialog(JFrame frame, String[] oldLimitStrings) {
        super(frame, I18n.tr("limitsdialog.title", new Object[0]), true);
        this.oldLimitStrings = oldLimitStrings;
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(10, 10));
        this.setContentPane(content);
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel input = new JPanel();
        input.setLayout(new GridLayout(4, 2, 5, 5));
        this.inputBoxes = new JTextField[4];
        int i = 0;
        while (i < 4) {
            this.inputBoxes[i] = new JTextField(oldLimitStrings[i]);
            input.add(new JLabel(String.valueOf(I18n.tr(names[i], new Object[0])) + ":"));
            input.add(this.inputBoxes[i]);
            ++i;
        }
        this.cancelButton = new JButton(I18n.tr("button.cancel", new Object[0]));
        this.okButton = new JButton(I18n.tr("button.ok", new Object[0]));
        this.getRootPane().setDefaultButton(this.okButton);
        JPanel buttons = new JPanel();
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        content.add((Component)new JLabel(I18n.tr("limitsdialog.question", new Object[0])), "North");
        content.add((Component)input, "Center");
        content.add((Component)buttons, "South");
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocation(frame.getX() + 50, frame.getY() + 75);
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = this.getX();
        int y = this.getY();
        if (x + this.getWidth() > screensize.width) {
            x = screensize.width - this.getWidth() - 30;
        }
        if (y + this.getHeight() > screensize.height) {
            y = screensize.height - this.getHeight() - 30;
        }
        this.setLocation(x, y);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SetLimitsDialog.this.dispose();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (SetLimitsDialog.this.checkInput()) {
                    SetLimitsDialog.this.dispose();
                }
            }
        });
    }

    private boolean checkInput() {
        this.changed = false;
        this.inputValues = null;
        String[] inputStrings = new String[4];
        int i = 0;
        while (i < 4) {
            inputStrings[i] = this.inputBoxes[i].getText();
            if (!inputStrings[i].equals(this.oldLimitStrings[i])) {
                this.changed = true;
            }
            ++i;
        }
        double[] values = new double[4];
        int i2 = 0;
        while (i2 < 4) {
            try {
                values[i2] = Double.parseDouble(inputStrings[i2]);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, I18n.tr("limitsdialog.error.NAN", inputStrings[i2], I18n.tr(names[i2], new Object[0])));
                this.inputBoxes[i2].selectAll();
                this.inputBoxes[i2].requestFocus();
                return false;
            }
            ++i2;
        }
        if (values[1] <= values[0]) {
            JOptionPane.showMessageDialog(this, I18n.tr("limitsdialog.error.xValuesOutOfOrder", new Object[0]));
            this.inputBoxes[1].selectAll();
            this.inputBoxes[1].requestFocus();
            return false;
        }
        if (values[3] <= values[2]) {
            JOptionPane.showMessageDialog(this, I18n.tr("limitsdialog.error.yValuesOutOfOrder", new Object[0]));
            this.inputBoxes[3].selectAll();
            this.inputBoxes[3].requestFocus();
            return false;
        }
        this.inputValues = values;
        return true;
    }

    public double[] getInputs() {
        return this.inputValues;
    }

    public double[] getInputsIfChanged() {
        if (this.changed) {
            return this.inputValues;
        }
        return null;
    }
}

