﻿Public Class Adder
    Implements INotifyPropertyChanged
    Public Event PropertyChanged As PropertyChangedEventHandler Implements INotifyPropertyChanged.PropertyChanged

    Private _augend As Double = 0
    Private _addend As Double = 0
    Private _sum As Double = 0

    Public Property Augend() As Double
        Set(ByVal value As Double)
            If _augend <> value Then
                _augend = value
                OnPropertyChanged(New PropertyChangedEventArgs("Augend"))
                CalculateNewSum()
            End If
        End Set
        Get
            Return _augend
        End Get
    End Property


    Public Property Addend() As Double
        Set(ByVal value As Double)
            If _addend <> value Then
                _addend = value
                OnPropertyChanged(New PropertyChangedEventArgs("Addend"))
                CalculateNewSum()
            End If
        End Set
        Get
            Return _addend
        End Get
    End Property


    Public Property Sum() As Double
        Protected Set(ByVal value As Double)
            If _sum <> value Then
                _sum = value
                OnPropertyChanged(New PropertyChangedEventArgs("Sum"))
            End If
        End Set

        Get
            Return _sum
        End Get
    End Property


    Private Sub CalculateNewSum()
        Sum = Augend + Addend
    End Sub


    Protected Overridable Sub OnPropertyChanged(ByVal args As PropertyChangedEventArgs)
        RaiseEvent PropertyChanged(Me, args)
    End Sub
End Class

