﻿Partial Public Class BorderedText
    Inherits UserControl
    Public Shared ReadOnly TextProperty =
        DependencyProperty.Register("Text",
                                    GetType(String),
                                    GetType(BorderedText),
                                    New PropertyMetadata(Nothing))


    Public Shared ReadOnly TextAlignmentProperty =
        DependencyProperty.Register("TextAlignment",
                                    GetType(TextAlignment),
                                    GetType(BorderedText),
                                    New PropertyMetadata(System.Windows.TextAlignment.Left))


    Public Shared ReadOnly TextDecorationsProperty =
        DependencyProperty.Register("TextDecorations",
                                    GetType(TextDecorationCollection),
                                    GetType(BorderedText),
                                    New PropertyMetadata(Nothing))


    Public Shared ReadOnly TextWrappingProperty =
        DependencyProperty.Register("TextWrapping",
                                    GetType(TextWrapping),
                                    GetType(BorderedText),
                                    New PropertyMetadata(System.Windows.TextWrapping.NoWrap))


    Public Shared ReadOnly CornerRadiusProperty =
        DependencyProperty.Register("CornerRadius",
                                    GetType(CornerRadius),
                                    GetType(BorderedText),
                                    New PropertyMetadata(New CornerRadius()))


    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property Text() As String
        Set(ByVal value As String)
            SetValue(TextProperty, value)
        End Set
        Get
            Return CStr(GetValue(TextProperty))
        End Get
    End Property


    Public Property TextAlignment() As TextAlignment
        Set(ByVal value As TextAlignment)
            SetValue(TextAlignmentProperty, value)
        End Set
        Get
            Return CType(GetValue(TextAlignmentProperty), TextAlignment)
        End Get
    End Property


    Public Property TextDecorations() As TextDecorationCollection
        Set(ByVal value As TextDecorationCollection)
            SetValue(TextDecorationsProperty, value)
        End Set
        Get
            Return CType(GetValue(TextDecorationsProperty), TextDecorationCollection)
        End Get
    End Property


    Public Property TextWrapping() As TextWrapping
        Set(ByVal value As TextWrapping)
            SetValue(TextWrappingProperty, value)
        End Set
        Get
            Return CType(GetValue(TextWrappingProperty), TextWrapping)
        End Get
    End Property


    Public Property CornerRadius() As CornerRadius
        Set(ByVal value As CornerRadius)
            SetValue(CornerRadiusProperty, value)
        End Set
        Get
            Return CType(GetValue(CornerRadiusProperty), CornerRadius)
        End Get
    End Property
End Class
