﻿Public Class Clock
    Implements INotifyPropertyChanged
    Private _hour, min, sec As Integer

    Private _date As Date

    Public Event PropertyChanged As PropertyChangedEventHandler Implements INotifyPropertyChanged.PropertyChanged


    Public Sub New()
        OnTimerTick(Nothing, Nothing)
        Dim tmr As New DispatcherTimer()
        tmr.Interval = TimeSpan.FromSeconds(0.1)
        AddHandler tmr.Tick, AddressOf OnTimerTick
        tmr.Start()
    End Sub


    Public Property Hour() As Integer
        Protected Set(ByVal value As Integer)
            If value <> _hour Then
                _hour = value
                OnPropertyChanged(New PropertyChangedEventArgs("Hour"))
            End If
        End Set
        Get
            Return _hour
        End Get
    End Property


    Public Property Minute() As Integer
        Protected Set(ByVal value As Integer)
            If value <> min Then
                min = value
                OnPropertyChanged(New PropertyChangedEventArgs("Minute"))
            End If
        End Set
        Get
            Return min
        End Get
    End Property


    Public Property Second() As Integer
        Protected Set(ByVal value As Integer)
            If value <> sec Then
                sec = value
                OnPropertyChanged(New PropertyChangedEventArgs("Second"))
            End If
        End Set
        Get
            Return sec
        End Get
    End Property


    Public Property [Date]() As Date
        Protected Set(ByVal value As Date)
            If value <> _date Then
                _date = value
                OnPropertyChanged(New PropertyChangedEventArgs("Date"))
            End If
        End Set
        Get
            Return _date
        End Get
    End Property


    Protected Overridable Sub OnPropertyChanged(ByVal args As PropertyChangedEventArgs)
        RaiseEvent PropertyChanged(Me, args)
    End Sub


    Private Sub OnTimerTick(ByVal sender As Object, ByVal args As EventArgs)
        Dim dt = Date.Now
        Hour = dt.Hour
        Minute = dt.Minute
        Second = dt.Second
        [Date] = Date.Today
    End Sub
End Class
