﻿Public Structure Complex
    Implements IFormattable
    Public Property Real() As Double
    Public Property Imaginary() As Double

    Public Sub New(ByVal real As Double, ByVal imaginary As Double)
        Me.Real = real
        Me.Imaginary = imaginary
    End Sub


    Public Overrides Function ToString() As String
        If Imaginary = 0 Then
            Return Real.ToString()
        End If

        Return String.Format("{0} {1} {2}i",
                             Real,
                             If(Math.Sign(Imaginary) >= 1, "+", "–"),
                             Math.Abs(Imaginary))
    End Function


    Public Overloads Function ToString(ByVal format As String,
                                       ByVal provider As IFormatProvider) As String Implements IFormattable.ToString
        If Imaginary = 0 Then
            Return Real.ToString(format, provider)
        End If

        Return String.Format(provider,
                             "{0} {1} {2}i",
                             Real.ToString(format, provider),
                             If(Math.Sign(Imaginary) >= 1, "+", "–"),
                             Math.Abs(Imaginary).ToString(format, provider))
    End Function
End Structure

