﻿Partial Public Class FlipPanel
    Inherits UserControl
    Public Shared ReadOnly Child1Property =
        DependencyProperty.Register("Child1",
                                    GetType(UIElement),
                                    GetType(FlipPanel),
                                    New PropertyMetadata(Nothing, AddressOf OnChild1Changed))

    Public Shared ReadOnly Child2Property =
        DependencyProperty.Register("Child2",
                                    GetType(UIElement),
                                    GetType(FlipPanel),
                                    New PropertyMetadata(Nothing, AddressOf OnChild2Changed))

    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property Child1() As UIElement
        Set(ByVal value As UIElement)
            SetValue(Child1Property, value)
        End Set
        Get
            Return CType(GetValue(Child1Property), UIElement)
        End Get
    End Property


    Public Property Child2() As UIElement
        Set(ByVal value As UIElement)
            SetValue(Child2Property, value)
        End Set
        Get
            Return CType(GetValue(Child2Property), UIElement)
        End Get
    End Property


    Public Sub Flip()
        flipStoryboard.Begin()
    End Sub


    Public Sub FlipBack()
        flipBackStoryboard.Begin()
    End Sub


    Private Shared Sub OnChild1Changed(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, FlipPanel).child1Container.Content = args.NewValue
    End Sub


    Private Shared Sub OnChild2Changed(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, FlipPanel).child2Container.Content = args.NewValue
    End Sub
End Class

