﻿
Public Class MultiplyConverter
    Implements IValueConverter
    Public Function Convert(ByVal value As Object,
                            ByVal targetType As Type,
                            ByVal parameter As Object,
                            ByVal culture As CultureInfo) As Object Implements IValueConverter.Convert
        Dim multiplier As Double

        If TypeOf value Is IConvertible AndAlso
            TypeOf parameter Is String AndAlso
            Double.TryParse(TryCast(parameter, String), multiplier) Then
            Return (TryCast(value, IConvertible)).ToDouble(culture) * multiplier
        End If
        Return value
    End Function


    Public Function ConvertBack(ByVal value As Object,
                                ByVal targetType As Type,
                                ByVal parameter As Object,
                                ByVal culture As CultureInfo) As Object Implements IValueConverter.ConvertBack
        Dim divider As Double

        If TypeOf value Is IConvertible AndAlso
            TypeOf parameter Is String AndAlso
            Double.TryParse(TryCast(parameter, String), divider) Then
            Return (TryCast(value, IConvertible)).ToDouble(culture) / divider
        End If
        Return value
    End Function
End Class

