﻿Partial Public Class RgbColorScroller
    Inherits UserControl
    Public Shared ReadOnly ColorProperty =
        DependencyProperty.Register("Color",
                                    GetType(Color),
                                    GetType(RgbColorScroller),
                                    New PropertyMetadata(Colors.Gray, AddressOf OnColorChanged))

    Public Event ColorChanged As RoutedPropertyChangedEventHandler(Of Color)

    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property Color() As Color
        Set(ByVal value As Color)
            SetValue(ColorProperty, value)
        End Set
        Get
            Return CType(GetValue(ColorProperty), Color)
        End Get
    End Property


    Private Sub OnColorColumnValueChanged(ByVal sender As Object, ByVal args As RoutedPropertyChangedEventArgs(Of Byte))
        Color = Color.FromArgb(255, redColumn.Value, greenColumn.Value, blueColumn.Value)
    End Sub


    Private Shared Sub OnColorChanged(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, RgbColorScroller).OnColorChanged(CType(args.OldValue, Color), CType(args.NewValue, Color))
    End Sub


    Protected Overridable Sub OnColorChanged(ByVal oldValue As Color, ByVal newValue As Color)
        redColumn.Value = newValue.R
        greenColumn.Value = newValue.G
        blueColumn.Value = newValue.B

        RaiseEvent ColorChanged(Me, New RoutedPropertyChangedEventArgs(Of Color)(oldValue, newValue))
    End Sub
End Class

