﻿Partial Public Class SaveFileDialog
    Inherits PhoneApplicationPage
    Private appService As PhoneApplicationService = PhoneApplicationService.Current
    Private okPressed As Boolean
    Private filename As String

    Public Sub New()
        InitializeComponent()
    End Sub


    Public Sub SetTitle(ByVal appTitle As String)
        ApplicationTitle.Text = appTitle
    End Sub


    Private Sub OnTextBoxTextChanged(ByVal sender As Object, ByVal args As TextChangedEventArgs)
        saveButton.IsEnabled = txtbox.Text.Length > 0
    End Sub


    Private Sub OnSaveButtonClick(ByVal sender As Object, ByVal args As RoutedEventArgs)
        okPressed = True
        filename = txtbox.Text
        Me.NavigationService.GoBack()
    End Sub


    Private Sub OnCancelButtonClick(ByVal sender As Object, ByVal args As RoutedEventArgs)
        okPressed = False
        Me.NavigationService.GoBack()
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        If appService.State.ContainsKey("filename") Then
            txtbox.Text = TryCast(appService.State("filename"), String)
        End If

        If appService.State.ContainsKey("apptitle") Then
            ApplicationTitle.Text = TryCast(appService.State("apptitle"), String)
        End If

        If Me.NavigationContext.QueryString.ContainsKey("FileName") Then
            txtbox.Text = Me.NavigationContext.QueryString("FileName")
        End If

        MyBase.OnNavigatedTo(args)
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        If Not String.IsNullOrEmpty(txtbox.Text) Then
            appService.State("filename") = txtbox.Text
        End If

        appService.State("apptitle") = ApplicationTitle.Text

        If TypeOf args.Content Is ISaveFileDialogCompleted Then
            TryCast(args.Content, ISaveFileDialogCompleted).
                SaveFileDialogCompleted(okPressed, filename)
        End If

        MyBase.OnNavigatedFrom(args)
    End Sub
End Class
