﻿Partial Public Class TapSlideToggle
    Inherits UserControl
    Public Shared ReadOnly IsCheckedProperty =
        DependencyProperty.Register("IsChecked",
                                    GetType(Boolean),
                                    GetType(TapSlideToggle),
                                    New PropertyMetadata(False,
                                                         AddressOf OnIsCheckedChanged))

    Public Event Checked As RoutedEventHandler
    Public Event Unchecked As RoutedEventHandler


    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property IsChecked() As Boolean
        Set(ByVal value As Boolean)
            SetValue(IsCheckedProperty, value)
        End Set
        Get
            Return CBool(GetValue(IsCheckedProperty))
        End Get
    End Property


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        args.Handled = True
        MyBase.OnManipulationStarted(args)
    End Sub


    Protected Overrides Sub OnManipulationCompleted(ByVal args As ManipulationCompletedEventArgs)
        Dim pt = args.ManipulationOrigin

        If pt.X > 0 AndAlso
            pt.X < Me.ActualWidth AndAlso
            pt.Y > 0 AndAlso
            pt.Y < Me.ActualHeight Then
            IsChecked = IsChecked Xor True
        End If

        args.Handled = True
        MyBase.OnManipulationCompleted(args)
    End Sub


    Private Shared Sub OnIsCheckedChanged(ByVal obj As DependencyObject,
                                          ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, TapSlideToggle).OnIsCheckedChanged(args)
    End Sub


    Private Sub OnIsCheckedChanged(ByVal args As DependencyPropertyChangedEventArgs)
        fillRectangle.Visibility = If(IsChecked, Visibility.Visible, Visibility.Collapsed)

        slideBorder.HorizontalAlignment = If(IsChecked, HorizontalAlignment.Right, HorizontalAlignment.Left)

        If IsChecked AndAlso CheckedEvent IsNot Nothing Then
            RaiseEvent Checked(Me, New RoutedEventArgs())
        End If

        If (Not IsChecked) AndAlso UncheckedEvent IsNot Nothing Then
            RaiseEvent Unchecked(Me, New RoutedEventArgs())
        End If
    End Sub
End Class

