﻿Public Class TwelveHourClock
    Inherits Clock

    Private _hour12 As Integer
    Private _isam, _ispm As Boolean


    Public Property Hour12() As Integer
        Protected Set(ByVal value As Integer)
            If value <> _hour12 Then
                _hour12 = value
                OnPropertyChanged(New PropertyChangedEventArgs("Hour12"))
            End If
        End Set
        Get
            Return _hour12
        End Get
    End Property


    Public Property IsAm() As Boolean
        Protected Set(ByVal value As Boolean)
            If value <> _isam Then
                _isam = value
                OnPropertyChanged(New PropertyChangedEventArgs("IsAm"))
            End If
        End Set
        Get
            Return _isam
        End Get
    End Property


    Public Property IsPm() As Boolean
        Protected Set(ByVal value As Boolean)
            If value <> _ispm Then
                _ispm = value
                OnPropertyChanged(New PropertyChangedEventArgs("IsPm"))
            End If
        End Set
        Get
            Return _ispm
        End Get
    End Property


    Protected Overrides Sub OnPropertyChanged(ByVal args As PropertyChangedEventArgs)
        If args.PropertyName = "Hour" Then
            Hour12 = (Hour - 1) Mod 12 + 1
            IsAm = Hour < 12
            IsPm = Not IsAm
        End If

        MyBase.OnPropertyChanged(args)
    End Sub
End Class

