﻿Public Class ValueToBrushConverter
    Implements IValueConverter
    Public Property Criterion() As Double
    Public Property GreaterThanBrush() As Brush
    Public Property EqualToBrush() As Brush
    Public Property LessThanBrush() As Brush


    Public Function Convert(ByVal value As Object,
                            ByVal targetType As Type,
                            ByVal parameter As Object,
                            ByVal culture As CultureInfo) As Object Implements IValueConverter.Convert
        Dim doubleVal = (TryCast(value, IConvertible)).ToDouble(culture)
        Return If(doubleVal >= Criterion,
                  If(doubleVal = Criterion, EqualToBrush, GreaterThanBrush),
                  LessThanBrush)
    End Function


    Public Function ConvertBack(ByVal value As Object,
                                ByVal targetType As Type,
                                ByVal parameter As Object,
                                ByVal culture As CultureInfo) As Object Implements IValueConverter.ConvertBack
        Return Nothing
    End Function
End Class

