﻿Public Class XamlCruncherTextBox
    Inherits TextBox
    Public Event XamlResult As EventHandler(Of XamlCruncherEventArgs)

    Public Sub New()
        Me.AcceptsReturn = True
        Me.TextWrapping = TextWrapping.NoWrap
        Me.HorizontalScrollBarVisibility = ScrollBarVisibility.Auto
        Me.VerticalScrollBarVisibility = ScrollBarVisibility.Auto
    End Sub


    Private Sub OnTextBoxTextChanged(ByVal sender As Object, ByVal args As TextChangedEventArgs) Handles Me.TextChanged
        Dim xaml = "<UserControl " &
            " xmlns='http://schemas.microsoft.com/winfx/2006/xaml/presentation'" & vbCr &
            " xmlns:phone='clr-namespace:Microsoft.Phone.Controls;" &
            "assembly=Microsoft.Phone'" & vbCr &
            " xmlns:shell='clr-namespace:Microsoft.Phone.Shell;" &
            "assembly=Microsoft.Phone'" & vbCr &
            " xmlns:system='clr-namespace:System;assembly=mscorlib'" & vbCr &
            " xmlns:petzold='clr-namespace:Petzold.Phone.Silverlight;" &
            "assembly=Petzold.Phone.Silverlight'>" & vbCr &
            "    " & Me.Text & vbCr & "</UserControl>"

        Dim ctrl As UserControl = Nothing

        Try
            ctrl = TryCast(XamlReader.Load(xaml), UserControl)
        Catch exc As Exception
            OnXamlResult(New XamlCruncherEventArgs(exc.Message))
            Return
        End Try

        If ctrl Is Nothing Then
            OnXamlResult(New XamlCruncherEventArgs("null result"))
            Return
        End If

        OnXamlResult(New XamlCruncherEventArgs(ctrl))
    End Sub


    Protected Overridable Sub OnXamlResult(ByVal args As XamlCruncherEventArgs)
        RaiseEvent XamlResult(Me, args)
    End Sub
End Class

