﻿Public Class QuadraticEquationSolver
    Implements INotifyPropertyChanged
    Private _solution1 As Complex
    Private _solution2 As Complex
    Private _hasTwoSolutions As Boolean
    Private _a, _b, _c As Double

    Public Event PropertyChanged As PropertyChangedEventHandler Implements INotifyPropertyChanged.PropertyChanged


    Public Property A() As Double
        Set(ByVal value As Double)
            If _a <> value Then
                _a = value
                OnPropertyChanged(New PropertyChangedEventArgs("A"))
                CalculateNewSolutions()
            End If
        End Set
        Get
            Return _a
        End Get
    End Property


    Public Property B() As Double
        Set(ByVal value As Double)
            If _b <> value Then
                _b = value
                OnPropertyChanged(New PropertyChangedEventArgs("B"))
                CalculateNewSolutions()
            End If
        End Set
        Get
            Return _b
        End Get
    End Property


    Public Property C() As Double
        Set(ByVal value As Double)
            If _c <> value Then
                _c = value
                OnPropertyChanged(New PropertyChangedEventArgs("C"))
                CalculateNewSolutions()
            End If
        End Set
        Get
            Return _c
        End Get
    End Property


    Public Property Solution1() As Complex
        Protected Set(ByVal value As Complex)
            If Not _solution1.Equals(value) Then
                _solution1 = value
                OnPropertyChanged(New PropertyChangedEventArgs("Solution1"))
            End If
        End Set

        Get
            Return _solution1
        End Get
    End Property


    Public Property Solution2() As Complex
        Protected Set(ByVal value As Complex)
            If Not _solution2.Equals(value) Then
                _solution2 = value
                OnPropertyChanged(New PropertyChangedEventArgs("Solution2"))
            End If
        End Set

        Get
            Return _solution2
        End Get
    End Property


    Public Property HasTwoSolutions() As Boolean
        Protected Set(ByVal value As Boolean)
            If _hasTwoSolutions <> value Then
                _hasTwoSolutions = value
                OnPropertyChanged(New PropertyChangedEventArgs("HasTwoSolutions"))
                OnPropertyChanged(New PropertyChangedEventArgs("HasOneSolution"))
            End If
        End Set

        Get
            Return _hasTwoSolutions
        End Get
    End Property


    Public ReadOnly Property HasOneSolution() As Boolean
        Get
            Return Not _hasTwoSolutions
        End Get
    End Property


    Private Sub CalculateNewSolutions()
        If A = 0 AndAlso B = 0 AndAlso C = 0 Then
            Solution1 = New Complex(0, 0)
            HasTwoSolutions = False
            Return
        End If

        If A = 0 Then
            Solution1 = New Complex(-C / B, 0)
            HasTwoSolutions = False
            Return
        End If

        Dim discriminant = B * B - 4 * A * C
        Dim denominator = 2 * A
        Dim real = -B / denominator
        Dim imaginary = Math.Sqrt(Math.Abs(discriminant)) / denominator

        If discriminant = 0 Then
            Solution1 = New Complex(real, 0)
            HasTwoSolutions = False
            Return
        End If

        Solution1 = New Complex(real, imaginary)
        Solution2 = New Complex(real, -imaginary)
        HasTwoSolutions = True
    End Sub


    Protected Overridable Sub OnPropertyChanged(ByVal args As PropertyChangedEventArgs)
        RaiseEvent PropertyChanged(Me, args)
    End Sub
End Class

