﻿Partial Public Class ColorColumn
    Inherits UserControl
    Public Shared ReadOnly ValueProperty =
        DependencyProperty.Register("Value",
                                    GetType(Byte),
                                    GetType(ColorColumn),
                                    New PropertyMetadata(CByte(0), AddressOf OnValueChanged))

    Public Shared ReadOnly LabelProperty =
        DependencyProperty.Register("Label",
                                    GetType(String),
                                    GetType(ColorColumn),
                                    New PropertyMetadata(AddressOf OnLabelChanged))

    Public Event ValueChanged As RoutedPropertyChangedEventHandler(Of Byte)


    Public Sub New()
        InitializeComponent()
    End Sub


    Public Property Value() As Byte
        Set(ByVal value As Byte)
            SetValue(ValueProperty, value)
        End Set
        Get
            Return CByte(GetValue(ValueProperty))
        End Get
    End Property


    Public Property Label() As String
        Set(ByVal value As String)
            SetValue(LabelProperty, value)
        End Set
        Get
            Return CStr(GetValue(LabelProperty))
        End Get
    End Property


    Private Sub OnSliderValueChanged(ByVal sender As Object, ByVal args As RoutedPropertyChangedEventArgs(Of Double))
        Value = CByte(args.NewValue)
    End Sub


    Private Shared Sub OnValueChanged(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, ColorColumn).OnValueChanged(CByte(args.OldValue), CByte(args.NewValue))
    End Sub


    Protected Overridable Sub OnValueChanged(ByVal oldValue As Byte, ByVal newValue As Byte)
        _slider.Value = newValue
        colorValue.Text = newValue.ToString("X2")

        RaiseEvent ValueChanged(Me, New RoutedPropertyChangedEventArgs(Of Byte)(oldValue, newValue))
    End Sub


    Private Shared Sub OnLabelChanged(ByVal obj As DependencyObject, ByVal args As DependencyPropertyChangedEventArgs)
        TryCast(obj, ColorColumn).colorLabel.Text = TryCast(args.NewValue, String)
    End Sub
End Class

