﻿Public Class ColorPresenter
    Private Shared colorNames() =
                {"AliceBlue", "AntiqueWhite", "Aqua", "Aquamarine", "Azure",
            "Beige", "Bisque", "Black", "BlanchedAlmond", "Blue", "BlueViolet",
            "Brown", "BurlyWood", "CadetBlue", "Chartreuse", "Chocolate",
            "Coral", "CornflowerBlue", "Cornsilk", "Crimson", "Cyan",
            "DarkBlue", "DarkCyan", "DarkGoldenrod", "DarkGray", "DarkGreen",
            "DarkKhaki", "DarkMagenta", "DarkOliveGreen", "DarkOrange",
            "DarkOrchid", "DarkRed", "DarkSalmon", "DarkSeaGreen",
            "DarkSlateBlue", "DarkSlateGray", "DarkTurquoise", "DarkViolet",
            "DeepPink", "DeepSkyBlue", "DimGray", "DodgerBlue", "Firebrick",
            "FloralWhite", "ForestGreen", "Fuchsia", "Gainsboro", "GhostWhite",
            "Gold", "Goldenrod", "Gray", "Green", "GreenYellow", "Honeydew",
            "HotPink", "IndianRed", "Indigo", "Ivory", "Khaki", "Lavender",
            "LavenderBlush", "LawnGreen", "LemonChiffon", "LightBlue",
            "LightCoral", "LightCyan", "LightGoldenrodYellow", "LightGray",
            "LightGreen", "LightPink", "LightSalmon", "LightSeaGreen",
            "LightSkyBlue", "LightSlateGray", "LightSteelBlue", "LightYellow",
            "Lime", "LimeGreen", "Linen", "Magenta", "Maroon",
            "MediumAquamarine", "MediumBlue", "MediumOrchid", "MediumPurple",
            "MediumSeaGreen", "MediumSlateBlue", "MediumSpringGreen",
            "MediumTurquoise", "MediumVioletRed", "MidnightBlue", "MintCream",
            "MistyRose", "Moccasin", "NavajoWhite", "Navy", "OldLace", "Olive",
            "OliveDrab", "Orange", "OrangeRed", "Orchid", "PaleGoldenrod",
            "PaleGreen", "PaleTurquoise", "PaleVioletRed", "PapayaWhip",
            "PeachPuff", "Peru", "Pink", "Plum", "PowderBlue", "Purple", "Red",
            "RosyBrown", "RoyalBlue", "SaddleBrown", "Salmon", "SandyBrown",
            "SeaGreen", "SeaShell", "Sienna", "Silver", "SkyBlue", "SlateBlue",
            "SlateGray", "Snow", "SpringGreen", "SteelBlue", "Tan", "Teal",
            "Thistle", "Tomato", "Turquoise", "Violet", "Wheat", "White",
            "WhiteSmoke", "Yellow", "YellowGreen"}

    Private Shared uintColors() As UInteger =
        {&HFFF0F8FFL, &HFFFAEBD7L, &HFF00FFFFL, &HFF7FFFD4L, &HFFF0FFFFL,
         &HFFF5F5DCL, &HFFFFE4C4L, &HFF000000L, &HFFFFEBCDL, &HFF0000FFL,
         &HFF8A2BE2L, &HFFA52A2AL, &HFFDEB887L, &HFF5F9EA0L, &HFF7FFF00L,
         &HFFD2691EL, &HFFFF7F50L, &HFF6495EDL, &HFFFFF8DCL, &HFFDC143CL,
         &HFF00FFFFL, &HFF00008BL, &HFF008B8BL, &HFFB8860BL, &HFFA9A9A9L,
         &HFF006400L, &HFFBDB76BL, &HFF8B008BL, &HFF556B2FL, &HFFFF8C00L,
         &HFF9932CCL, &HFF8B0000L, &HFFE9967AL, &HFF8FBC8FL, &HFF483D8BL,
         &HFF2F4F4FL, &HFF00CED1L, &HFF9400D3L, &HFFFF1493L, &HFF00BFFFL,
         &HFF696969L, &HFF1E90FFL, &HFFB22222L, &HFFFFFAF0L, &HFF228B22L,
         &HFFFF00FFL, &HFFDCDCDCL, &HFFF8F8FFL, &HFFFFD700L, &HFFDAA520L,
         &HFF808080L, &HFF008000L, &HFFADFF2FL, &HFFF0FFF0L, &HFFFF69B4L,
         &HFFCD5C5CL, &HFF4B0082L, &HFFFFFFF0L, &HFFF0E68CL, &HFFE6E6FAL,
         &HFFFFF0F5L, &HFF7CFC00L, &HFFFFFACDL, &HFFADD8E6L, &HFFF08080L,
         &HFFE0FFFFL, &HFFFAFAD2L, &HFFD3D3D3L, &HFF90EE90L, &HFFFFB6C1L,
         &HFFFFA07AL, &HFF20B2AAL, &HFF87CEFAL, &HFF778899L, &HFFB0C4DEL,
         &HFFFFFFE0L, &HFF00FF00L, &HFF32CD32L, &HFFFAF0E6L, &HFFFF00FFL,
         &HFF800000L, &HFF66CDAAL, &HFF0000CDL, &HFFBA55D3L, &HFF9370DBL,
         &HFF3CB371L, &HFF7B68EEL, &HFF00FA9AL, &HFF48D1CCL, &HFFC71585L,
         &HFF191970L, &HFFF5FFFAL, &HFFFFE4E1L, &HFFFFE4B5L, &HFFFFDEADL,
         &HFF000080L, &HFFFDF5E6L, &HFF808000L, &HFF6B8E23L, &HFFFFA500L,
         &HFFFF4500L, &HFFDA70D6L, &HFFEEE8AAL, &HFF98FB98L, &HFFAFEEEEL,
         &HFFDB7093L, &HFFFFEFD5L, &HFFFFDAB9L, &HFFCD853FL, &HFFFFC0CBL,
         &HFFDDA0DDL, &HFFB0E0E6L, &HFF800080L, &HFFFF0000L, &HFFBC8F8FL,
         &HFF4169E1L, &HFF8B4513L, &HFFFA8072L, &HFFF4A460L, &HFF2E8B57L,
         &HFFFFF5EEL, &HFFA0522DL, &HFFC0C0C0L, &HFF87CEEBL, &HFF6A5ACDL,
         &HFF708090L, &HFFFFFAFAL, &HFF00FF7FL, &HFF4682B4L, &HFFD2B48CL,
         &HFF008080L, &HFFD8BFD8L, &HFFFF6347L, &HFF40E0D0L, &HFFEE82EEL,
         &HFFF5DEB3L, &HFFFFFFFFL, &HFFF5F5F5L, &HFFFFFF00L, &HFF9ACD32L}

    ' Static constructor
    Shared Sub New()
        Colors = New ColorPresenter(139) {}

        For i = 0 To 139
            ' Break down the color into components
            Dim A = CByte((uintColors(i) And &HFF000000L) >> 24)
            Dim R = CByte((uintColors(i) And &HFF0000) >> 16)
            Dim G = CByte((uintColors(i) And &HFF00) >> 8)
            Dim B = CByte((uintColors(i) And &HFF) >> 0)

            ' Create a display name for the color
            Dim builder As New StringBuilder()

            For Each ch In colorNames(i)
                If builder.Length = 0 OrElse Char.IsLower(ch) Then
                    builder.Append(ch)
                Else
                    builder.Append(" "c)
                    builder.Append(ch)
                End If
            Next ch

            ' Create a ColorPresenter for each color
            Dim clrPresenter As New ColorPresenter()
            clrPresenter.Color = Color.FromArgb(A, R, G, B)
            clrPresenter.Name = colorNames(i)
            clrPresenter.DisplayName = builder.ToString()
            clrPresenter.Brush = New SolidColorBrush(clrPresenter.Color)

            ' Add it to the static array
            Colors(i) = clrPresenter
        Next i
    End Sub


    Private Shared _Colors As ColorPresenter()
    Public Shared Property Colors() As ColorPresenter()
        Get
            Return _Colors
        End Get
        Protected Set(ByVal value As ColorPresenter())
            _Colors = value
        End Set
    End Property


    Private _Color As Color
    Public Property Color() As Color
        Get
            Return _Color
        End Get
        Protected Set(ByVal value As Color)
            _Color = value
        End Set
    End Property


    Private _Name As String
    Public Property Name() As String
        Get
            Return _Name
        End Get
        Protected Set(ByVal value As String)
            _Name = value
        End Set
    End Property


    Private _DisplayName As String
    Public Property DisplayName() As String
        Get
            Return _DisplayName
        End Get
        Protected Set(ByVal value As String)
            _DisplayName = value
        End Set
    End Property


    Private _Brush As Brush
    Public Property Brush() As Brush
        Get
            Return _Brush
        End Get
        Protected Set(ByVal value As Brush)
            _Brush = value
        End Set
    End Property


    Public Overrides Function ToString() As String
        Return Name
    End Function
End Class
